using System;
using System.Collections.Generic;
using System.Text;
using System.DirectoryServices;

    static class ADuser
    {
        public static int getUserInfo(string p_user, string p_property, out string p_value)
        {
            string path = "LDAP://dc=dsp01,dc=local";
            using (DirectoryEntry entry = new DirectoryEntry(path))
            {
                using (DirectorySearcher search = new DirectorySearcher(entry))
                {
                    try
                    {
                        search.Filter = "(sAMAccountName=" + p_user + ")";
                        SearchResultCollection scn = search.FindAll();
                        if (scn.Count != 0)
                        {
                            p_value = scn[0].Properties[p_property][0].ToString();
                            return 0;
                        }
                        else
                        {
                            p_value = null;
                            return -1; //[Uo^
                        }
                    }
                    catch (System.ArgumentOutOfRangeException)
                    {
                        p_value = null;
                        return -2; //Yo^
                    }
                    catch (System.Exception)
                    {
                        p_value = null;
                        return -3; //zOG[
                    }
                }
            }
        }
    }
